ROWS=10
COLS=10
def load_world(filename):
    world = []
    with open(filename) as f:
        for line in f:
            row = line.split()
            world.append(row)
    assert len(world) == ROWS
    for row in world:
        assert len(row) == COLS
    return world

def print_world(world: list[list[str]], r: int, c: int) -> None:
# Ορισμός συνάρτησης για την εμφάνιση της τρέχουσας κατάστασης του κόσμου. 
# Δέχεται τον κόσμο (world) και την τρέχουσα θέση του ρομπότ: γραμμή (r) και στήλη (c). 
# Δεν επιστρέφει τιμή (None), απλώς εκτυπώνει στην οθόνη. 

    for i in range(ROWS):
    # Επανάληψη (loop) για κάθε γραμμή (i) του πλέγματος από 0 έως ROWS-1 (δηλαδή 0 έως 9). [cite: 130]

        line = []
        # Αρχικοποιεί μια κενή λίστα 'line' που θα αποθηκεύσει τα σύμβολα της τρέχουσας γραμμής προς εκτύπωση. [cite: 131]

        for j in range(COLS):
        # Επανάληψη (loop) για κάθε στήλη (j) του πλέγματος από 0 έως COLS-1 (δηλαδή 0 έως 9). [cite: 132]

            line.append("R" if (i,j)==(r,c) else world[i][j])
            # Προσθέτει το σύμβολο στο 'line'. 
            # Χρησιμοποιεί τριαδικό τελεστή: 
            #   - Εάν η τρέχουσα θέση (i, j) είναι η θέση του ρομπότ (r, c), προσθέτει το σύμβολο **"R"** (Robot). [cite: 133]
            #   - Διαφορετικά, προσθέτει το αρχικό σύμβολο του κελιού από τον κόσμο (**world[i][j]**). [cite: 133]

        print(" ".join(line))
        # Ενώνει τα στοιχεία της λίστας 'line' με ένα **κενό** (" ") ως διαχωριστή και εκτυπώνει την τελική συμβολοσειρά (τη γραμμή). [cite: 134]

    print()
    # Εκτυπώνει μια κενή γραμμή για οπτικό διαχωρισμό μετά την εμφάνιση του πλέγματος. [cite: 135]

#############################################
#print_world(load_world("world_001.txt"),0,0)
#print_world(load_world("world_001.txt"),0,1)
#############################################

def in_bounds(r: int, c: int) -> bool:
# Ορισμός συνάρτησης για τον έλεγχο ορίων.
# Δέχεται συντεταγμένες γραμμής (r) και στήλης (c) ως ακέραιους (int).
# Επιστρέφει μια λογική τιμή (bool: True/False).

    return 0 <= r < ROWS and 0 <= c < COLS
    # Επιστρέφει True αν:
    # 1. Η γραμμή (r) είναι μεγαλύτερη ή ίση του 0 και αυστηρά μικρότερη από ROWS (10).
    # 2. Η στήλη (c) είναι μεγαλύτερη ή ίση του 0 και αυστηρά μικρότερη από COLS (10).
    # Και οι δύο συνθήκες πρέπει να ισχύουν (and).

def next_step_bfs(world, pos):
    path = bfs_path_to_nearest_item(world, pos)
    return path[0] if path else pos

def next_step_sweep(world, r, c, direction):
    # υλοποιημένη για να επικεντρωθείτε στο BFS
    if direction == 1 and c == COLS - 1:
        return (r + 1 if r + 1 < ROWS else r, c, -1)
    if direction == -1 and c == 0:
        return (r + 1 if r + 1 < ROWS else r, c, 1)
    return (r, c + direction, direction)

def run(strategy="BFS", verbose_every=10):
    world = load_world("world.txt")
    r, c = 0, 0
    direction = 1
    score, steps = 0, 0

    while steps < 80:
        if world[r][c] == ITEM:
            world[r][c] = EMPTY
            score += 1
            if not any(ITEM in row for row in world):
                break

        if strategy.upper() == "BFS":
            nr, nc = next_step_bfs(world, (r, c))
            r, c = (nr, nc)
        else:
            r, c, direction = next_step_sweep(world, r, c, direction)

        steps += 1

        if verbose_every and steps % verbose_every == 0:
            print(f"Step {steps} | Pos=({r},{c}) | Score={score} | Strat={strategy}")
            print_world(world, r, c)

    print(f"Τελικό σκορ: {score}, Βήματα: {steps}, Στρατηγική: {strategy}")


    
