# 2D Lists in Python - Creation, Access, and Manipulation

def create_2d_list(rows, cols, fill_value=0):
    """
    Creates a 2D list with given rows and columns, filled with fill_value.
    Includes validation for positive dimensions.
    """
    if not (isinstance(rows, int) and isinstance(cols, int)):
        raise TypeError("Rows and columns must be integers.")
    if rows <= 0 or cols <= 0:
        raise ValueError("Rows and columns must be positive integers.")
    
    return [[fill_value for _ in range(cols)] for _ in range(rows)]

def print_2d_list(matrix):
    """Nicely prints a 2D list."""
    for row in matrix:
        print(" ".join(map(str, row)))
    print()

# Example usage
try:
    
    # Create a 3x4 matrix filled with zeros
    matrix = create_2d_list(3, 4, 0)
    print("Initial 3x4 matrix:")
    print_2d_list(matrix)

    # Modify some elements
    matrix[0][0] = 5
    matrix[1][2] = 9
    matrix[2][3] = 7
    print("After modifications:")
    print_2d_list(matrix)

    # Accessing elements safely
    row_index, col_index = 1, 2
    if 0 <= row_index < len(matrix) and 0 <= col_index < len(matrix[0]):
        print(f"Element at ({row_index}, {col_index}): {matrix[row_index][col_index]}")
    else:
        print("Index out of range.")

    # Iterating through all elements
    print("\nAll elements in the matrix:")
    for r in range(len(matrix)):
        for c in range(len(matrix[r])):
            print(f"matrix[{r}][{c}] = {matrix[r][c]}")

except (TypeError, ValueError) as e:
    print(f"Error: {e}")
