#include <iostream>
#include "functions.hpp"

// Always read the c++ standard from this site:
// cppreference.com

int main(void)
{
    // Variables "a","b" with values "2" and "4" respectively.
    int a = 2;
    int b = 4;

    // Every variable in c++ has its own memory location.
    // Access the memory location
    // of a variable always with the ampersand operator.
    std::cout << &a << std::endl;

    // Bind the memory location of variable "a" to a new variable "ptr_a"
    // which is pointer to type integer.
    int* ptr_a = &a;

    // The types between variable and pointer to variable should always match.
    //float* ptr_b = &b; //wrong

    // The value of variable "ptr_a" and
    // the memory location of variable "a" are the same thing.
    std::cout << ptr_a << " " << &a << std::endl;

    // Every pointer is a variable and thus it has each own memory location.
    // Hence, the memory location of variable "ptr_a" and
    // and the memory location of variable "a" are different.
    std::cout << &ptr_a << " " << &a << std::endl;

    // We always access the contents of pointer with the asterisk operator.
    // Accessing the value of variable "a" through pointer variable "ptr_a",
    // outputs the same result.
    std::cout << *ptr_a << " " << a << std::endl;

    // Changing the value of variable "a"
    // also changes the value accessed through the pointer variable "ptr_a"
    a = 4;
    std::cout << *ptr_a << " " << a << std::endl;

    // Changing the value accessed through pointer variable "ptr_a"
    // also changes the value of a
    *ptr_a = 2;
    std::cout << *ptr_a << " " << a << std::endl;

    // We can make an alias for an existing variable using the ampersand operator.
    // To create an alias just assign the variable to a variable reference of the same type,.
    int& ref_a = a;

    // Types between assigned variabled and reference types should always match.
    //float& ref_b = b; //wrong

    // Value of variable "a" and reference variable  "ref_a" is the same.
    std::cout << ref_a << " " << a << std::endl;

    // Memory location of the two variables is also the same.
    std::cout << &ref_a << " " << &a << std::endl;

    // Changing the value of variable "a"
    // also changes the value of reference variable "ref_a"
    a = 4;
    std::cout << ref_a << " " << a << std::endl;

    // Changing the value of reference variable "ref_a"
    // also changes the value of a
    ref_a = 5;
    std::cout << ref_a << " " << a << std::endl;

    // In general refences are closely related to pointers.
    // But refences cannot be nullptr, can only be assigned once
    // and always reference existing variables of the program.

////////////////////////////////////////////////////////////////////////////////////

    // A static array of 4 elements of type integer.
    // Initialized with some random values.
    int static_intArr[4] = { 1, 2, 3, 4 };

    // Size of static arrays is always constant.
    // int c = 2;
    // int static_intArr[c] = {}; // wrong

    // const int c = 2;
    // int static_intArr[c] = {}; // correct but still, we are ought to know the size prior to the program execution.

    // Instead we can use dynamic allocation during runtime.
    // Create a dynamic array of 4 elements. Each one of type integer.
    int* dynamic_int3 = new int[4];
    // int c = 4;
    // int* dynamic_int3 = new int[c]; // also correct.

    // Access the second element of the array and assign a new value
    // with subscript operator.
    dynamic_int3[1] = 2;

    // Access the second element of the array and assign a new value
    // with pointer arithmetics.
    *(dynamic_int3 + 1) = 2;

    // Get the memory location of the variable array.
    std::cout << &dynamic_int3 << std::endl;

    // Get the memory location of the first element of the variable array.
    std::cout << &(dynamic_int3[0]) << std::endl;

    // Delete the array with the appropriate operator.
    delete[] dynamic_int3;

    // We can also allocate space for just a variable.
    // Will be useful for classes/structs etc.
    int* dynamic_int = new int;

    // Also deleting the allocated memory with the appropriate operator.
    delete dynamic_int;

    // Equivalently, we can allocate dynamic memory with the malloc function.
    // Takes as input the size of the requested memory in bytes and
    // returns void* that needs to be casted to the appropriate type.
    int* dynamic_int1 = (int*)malloc(sizeof(int));
    int* dynamic_int2 = (int*)malloc(sizeof(int) * 4);


    // And deallocate the memory with the appropriate function call.
    free(dynamic_int1);
    free(dynamic_int2);

    // Never assign a pointer variable to a new memory location before deallocating.
    // Produces a memory leak since u cannot recover the original memory location
    // of the memory pointed by the pointer variable (unless u save it somewhere).
    // int * ptr_b = new int;
    // ptr_b = &b;
    // delete ptr_b; // error and leak

    // Since arrays can have any type of value, we can also have an array with
    // elements of type pointer to integer.
    int** var7 = new int* [4];

    // Assign other memory locations
    var7[0] = &a;

    // Or Allocate new memory.
    var7[0] = new int;

    // That needs to be deallocated before destroying the array.
    delete var7[0];
    delete[] var7;


    int var1 = 2;
    int var2 = 4;

    // Function callers are identical to the assignment operators we used earlier.
    // Arguments: int a, int b
    // Calling the function is similar to : int a = var1, int b = var2
    // Assigning variables to other variables without reference or pointer
    // just copies the contents of the right hand variable to the left hand variable.
    // Thus, we end up with 2 distinct and independant variables.
    // Therefore, this function call does nothing on var1/var2.
    swap1(var1, var2);
    std::cout << var1 << " " << var2 << std::endl;

    // Arguments: int & a, int & b
    // Calling the function is similar to : int & a = var1, int & b = var2
    // Creating aliases for variables enables us to access and manipulate both of them 
    // at the same time. Therefore, this function call does the swap operation
    // successfully.
    swap2(var1, var2);
    std::cout << var1 << " " << var2 << std::endl;

    // Arguments: int * a, int * b
    // Calling the function is similar to : int * a = &var1, int * b = &var2
    // Creating pointers to variable memories enables us to access and manipulate both of them
    // at the same time. Therefore, this function call does the swap operation
    // successfully.
    swap3(&var1, &var2);
    std::cout << var1 << " " << var2 << std::endl;

    // Additionally you many want to pass arguments by reference or by pointer
    // in order to avoid deep copies without necessarily mean that your function
    // will change the contents of them. This is usually done (but not a must) 
    // by declaring the function arguments as const.

    // We can also pass a variable by pointer in order to
    // allocate memory of some size.
    int* ptr_var3 = nullptr;
    my_allocArr(ptr_var3, 4);

    // And destroy the contents of a pointer.
    my_destroy(ptr_var3);

    // We can also allocate memory through a function and return the pointer
    // as an assigment to pointer variable "ptr_var3"
    ptr_var3 = my_allocArr(4);
    my_destroy(ptr_var3);

    int static_varArr[4] = { 1, 2, 3, 4 };

    // Returning a reference to an element of an array
    // can directly change the value of that index.
    atIndex(static_varArr, 0) = 0;

    // Returning a reference to an element of an array
    // and assigning it to a plain variable just creates a copy.
    int var4 = atIndex(static_varArr, 0);

    // Returning a reference to an element of an array
    // and assigning it to a reference variable creates an alias
    // for the indexed array element.
    int& ref_var4 = atIndex(static_varArr, 0);

    // Changing the referenced value, will change the indexed array element
    // but it will not change the copy we created earlier.
    ref_var4 = 2;
    std::cout << ref_var4 << " " << static_varArr[0] << " " << var4 << std::endl;

    // Additionally we can have variable of some type.
    int var5 = 5;

    // Assign its memory location to a variable of pointer and of same type.
    int* ptr_var5 = &var5;

    // And create a reference variable for the pointer variable.
    int*& ref_ptr_var = ptr_var5;

    // Changes to the value of any of the above variables, will be reflected to
    // all of them.
    *ref_ptr_var = 4;
    std::cout << var5 << " " << *ptr_var5 << " " << *ref_ptr_var << std::endl;

    return 0;
}