/* SimpleApp.scala */
import org.apache.spark._
import org.apache.spark.SparkContext._

object wordCount {
    def main(args: Array[String]) {
      val inputFile = args(0)
      val outputFile = args(1)
      val conf = new SparkConf().setAppName("wordCount")
      // Create a Scala Spark Context.
      val sc = new SparkContext(conf)
      // Load our input data.
      //val input =  sc.textFile(inputFile)
      val input =  sc.textFile("file:///home/lab/myprj/wordCount/"+inputFile)
      // Split up into words.
      val words = input.flatMap(line => line.split(" "))
      // Transform into word and count.
      val counts = words.map(word => (word, 1)).reduceByKey ( (x, y) => x + y)
      // Save the word count back out to a text file, causing evaluation.
      counts.saveAsTextFile("file:///home/lab/myprj/wordCount/"+outputFile)
    }
}
