public class Main
{
    public static void main(String[] args)
    {
        //We create the players and the board
        //MaxDepth for the MiniMax algorithm is set to 2; feel free to change the values
        Player playerX = new Player(2, Board.X);
        Player playerO = new Player(2, Board.O);
        Board board = new Board();
        board.print();

        //Put this out of comments for the O to play first
        //board.setLastLetterPlayed(Board.X);

        while(!board.isTerminal())
        {
            System.out.println();
            switch(board.getLastPlayer())
            {
                //If X played last, then Ο plays now
                case Board.X:
                    System.out.println("O plays");
                    Move moveO = playerO.MiniMax(board);
                    board.makeMove(moveO.getRow(), moveO.getCol(), Board.O);
                    break;
                //If O played last, then X plays now
                case Board.O:
                    System.out.println("X plays");
                    Move moveX = playerX.MiniMax(board);
                    board.makeMove(moveX.getRow(), moveX.getCol(), Board.X);
                    break;
                default:
                    break;
            }
            board.print();
        }
    }
}
